$(function () {
    tampil_data();
    function tampil_data() {
        var tahun = $("#tahun_ini").val();
        data_penjualan(tahun);
    }

    $("#cek_grafirk").change(function () {
        var tahun = $(this).val();
        data_penjualan(tahun);
    });
    data_penjualan();
    function data_penjualan(tahun) {
        var token = $("meta[name='csrf-token']").attr("content");

        $.ajax({
            type: "POST",
            url: "data-penjualan",
            dataType: "JSON",
            data: {
                tahun: tahun,
                _token: token,
            },
            success: function (data) {
                $("#order").html(data.order);
                $("#transaksi").html(data.transaksi);
                $("#produk").html(data.produk);
                $("#member").html(data.member);
                $("#dttran").html(data.dttran);

                $("#ttlp").html(data.ttlp);
                $("#ttlpg").html(data.ttlpg);
                $("#ttlpr").html(data.ttlpr);
                $("#rata").html(data.rata);
                // $("#cekpen").html(data.pendapatan);

                $("#nmmember2").html(data.nmmember2);
                produk_terlaris(tahun);

                $("#salesChart").remove();
                $(".chart").append(
                    `<canvas id="salesChart" height="210" style="height: 210px;"></canvas>`
                );
                grafik(
                    data.bulan,
                    data.pendapatan,
                    data.pengeluaran,
                    data.profit
                );

                grafik_member(data.total, data.nmmember);
            },
        });
    }

    produk_terlaris();
    function produk_terlaris(tahun) {
        var token = $("meta[name='csrf-token']").attr("content");
        $.ajax({
            type: "POST",
            url: "produk-terlaris",
            data: {
                tahun: tahun,
                _token: token,
            },
            success: function (data) {
                $("#produk_terlaris").html(data);
            },
        });
    }
    grafik();
    function grafik(bulan, pendapatan, pengeluaran, profit) {
        var salesChartCanvas = $("#salesChart").get(0).getContext("2d");

        var salesChartData = {
            labels: bulan,
            datasets: [
                {
                    label: "Pendapatan",
                    backgroundColor: "#FB0102",
                    data: pendapatan,
                },
                {
                    label: "Pengeluaran",
                    backgroundColor: "#FE4648",
                    data: pengeluaran,
                },
                {
                    label: "Profit",
                    backgroundColor: "#FF7A7B",
                    data: profit,
                },
            ],
        };
        var salesChartOptions = {
            maintainAspectRatio: false,
            responsive: true,
            legend: {
                display: false,
            },
            scales: {
                xAxes: [
                    {
                        gridLines: {
                            display: true,
                        },
                    },
                ],
                yAxes: [
                    {
                        gridLines: {
                            display: true,
                        },
                    },
                ],
                yAxes: [
                    {
                        gridLines: {
                            display: true,
                        },
                        ticks: {
                            beginAtZero: true,
                            stepSize: 500000,
                            callback: function (value, index, values) {
                                if (parseInt(value) >= 1000) {
                                    return (
                                        "Rp " +
                                        value
                                            .toString()
                                            .replace(
                                                /\B(?=(\d{3})+(?!\d))/g,
                                                "."
                                            )
                                    );
                                } else {
                                    return "Rp " + value;
                                }
                            },
                        },
                    },
                ],
            },
            tooltips: {
                callbacks: {
                    label: function (t, d) {
                        var xLabel = d.datasets[t.datasetIndex].label;
                        var yLabel =
                            t.yLabel >= 1000
                                ? "Rp " +
                                  t.yLabel
                                      .toString()
                                      .replace(/\B(?=(\d{3})+(?!\d))/g, ",")
                                : "Rp " + t.yLabel;
                        return xLabel + ": " + yLabel;
                    },
                },
            },
        };

        // This will get the first returned node in the jQuery collection.
        // eslint-disable-next-line no-unused-vars
        var salesChart = new Chart(salesChartCanvas, {
            type: "bar",
            data: salesChartData,
            options: salesChartOptions,
        });
    }

    grafik_member();
    function grafik_member(total, nmmember) {
        var pieChartCanvas = $("#pieChart").get(0).getContext("2d");
        var pieData = {
            labels: nmmember,
            datasets: [
                {
                    data: total,
                    backgroundColor: [
                        "#7E0100",
                        "#AB0001",
                        "#CF0200",
                        "#FF0100",
                        "#FF2928",
                        "#A70100",
                        "#FE0000",
                        "#FF5455",
                        "#FE7A7C",
                        "#FFBBB9",
                    ],
                },
            ],
        };
        var pieOptions = {
            legend: {
                display: false,
            },
        };
        // Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        // eslint-disable-next-line no-unused-vars
        var pieChart = new Chart(pieChartCanvas, {
            type: "doughnut",
            data: pieData,
            options: pieOptions,
        });

        //-----------------
        // - END PIE CHART -
        //-----------------

        /* jVector Maps
         * ------------
         * Create a world map with markers
         */
        $("#world-map-markers").mapael({
            map: {
                name: "usa_states",
                zoom: {
                    enabled: true,
                    maxLevel: 10,
                },
            },
        });
    }
});
